reportextension 70167825 "NCCR Standard Sales - Invoice" extends "Standard Sales - Invoice"
{
    dataset
    {
        add(Header)
        {
            column(NCCRDataExists; NCCRReportDataMgt.GetSalesInvoiceNCCRData(Header))
            {
            }
            column(NCCRPosting; Header."NCCR Posting")
            {
            }
            column(NCCRHeader; NCCRReportDataMgt.GetTempNCCRHeader())
            {
            }
            column(NCCRFooter; NCCRReportDataMgt.GetTempNCCRFooter())
            {
            }
            column(NCCRPaymentAmount; NCCRReportDataMgt.GetNCCRPaymentAmount())
            {
                AutoFormatExpression = Header."Currency Code";
            }
            column(NCCRPaymentAmountText; NCCRReportDataMgt.GetNCCRPaymentAmountText())
            {
            }
            column(NCCRPaymentDiscountAmount; NCCRReportDataMgt.GetNCCRPaymentDiscountAmount())
            {
                AutoFormatExpression = Header."Currency Code";
            }
            column(NCCRPaymentDiscountAmountText; NCCRReportDataMgt.GetNCCRPaymentDiscountAmountText())
            {
            }
        }

        addafter(Line)
        {
            dataitem(NCCRQRCode; Integer)
            {
                DataItemTableView = sorting(Number);

                column(NCCRQRNumber; Number)
                {
                }
                column(NCCRQRText; TempSignatureNCCREntryDocumentData.GetData())
                {
                }
                column(NCCRQRImage; TempSignatureNCCREntryDocumentData."QR Code")
                {
                }
                column(NCCRQRImageHasValue; TempSignatureNCCREntryDocumentData."QR Code".HasValue())
                {
                }
                column(NCCRQRSize; Format(TempSignatureNCCREntryDocumentData."QR Code Size", 0, 2))
                {
                }

                trigger OnPreDataItem()
                begin
                    NCCRReportDataMgt.GetTempSignatureNCCREntryDocumentData(TempSignatureNCCREntryDocumentData);
                    SetRange(Number, 1, TempSignatureNCCREntryDocumentData.Count());
                end;

                trigger OnAfterGetRecord()
                begin
                    if (Number = 1) then
                        TempSignatureNCCREntryDocumentData.Find('-')
                    else
                        TempSignatureNCCREntryDocumentData.Next();
                    TempSignatureNCCREntryDocumentData.CalcFields("QR Code");
                end;
            }
        }
    }

    rendering
    {
        layout("NCCR Default Layout")
        {
            Type = RDLC;
            LayoutFile = './src/reportext/NCCRStandardSalesInvoice.rdlc';
            Caption = 'Cash Register Default Layout', Comment = 'DEU="Registrierkasse Standardlayout"';
            Summary = 'The default layout of the Cash Register resp. the fiskaltrust POS Interface.', Comment = 'DEU="Das Standardlayout der Registrierkasse bzw. vom fiskaltrust POS Interface."';
        }
    }

    var
        TempSignatureNCCREntryDocumentData: Record "NCCR Entry Document Data" temporary;
        NCCRReportDataMgt: Codeunit "NCCR Report Data Mgt.";
}